<?php

error_reporting(E_ALL);
ini_set('display_errors', 1);

// --- 1. تنظیم مسیر ریشه (Root Path) ---
// استفاده از مسیر مطلقی که شما دادید برای جلوگیری از خطای ../
$base_path = '/home/nahidkha/bot.khazaesafrron.ir';

// بررسی اطمینان (اگر مسیر هاردکد شده اشتباه بود، تلاش برای مسیر نسبی)
if (!file_exists($base_path . '/config.php')) {
    $base_path = dirname(__DIR__); // معادل __DIR__ . '/..'
}

// بررسی نهایی وجود فایل کانفیگ
if (!file_exists($base_path . '/config.php')) {
    die("Critical Error: config.php not found at: " . $base_path . "/config.php");
}

// --- 2. فراخوانی فایل‌ها با متغیر $base_path ---
require_once $base_path . '/config.php';
require_once $base_path . '/src/Database/Connection.php';
require_once $base_path . '/src/Utils/DateTimeHelpers.php'; // برای تاریخ شمسی
require_once $base_path . '/src/Utils/FormattingHelpers.php';
require_once $base_path . '/src/Utils/GeneralHelpers.php';

require_once $base_path . '/src/Database/OrderQueries.php';
require_once $base_path . '/src/Database/LogQueries.php';
require_once $base_path . '/src/Database/UserQueries.php';
require_once $base_path . '/src/Database/TransactionQueries.php';
require_once $base_path . '/src/Services/ZibalService.php';
require_once $base_path . '/src/Services/BotApiService.php';
require_once $base_path . '/src/Utils/KeyboardBuilders.php';

// --- 3. توابع و منطق اصلی ---

function sendMessageToUser(?int $telegram_chat_id, ?int $bale_chat_id, string $message, ?array $reply_markup = null): void {
    if (defined('ERROR_LOG_PATH')) {
        $log_entry = date('Y-m-d H:i:s') . " - [Zibal Callback Notify] Sending message.\n";
        file_put_contents(ERROR_LOG_PATH, $log_entry, FILE_APPEND);
    }

    if ($telegram_chat_id) {
        sendPushMessage('telegram', $telegram_chat_id, $message, $reply_markup);
    }
    if ($bale_chat_id) {
        sendPushMessage('bale', $bale_chat_id, $message, $reply_markup);
    }
}

$trackId = $_GET['trackId'] ?? null;
$success = $_GET['success'] ?? null;
$status = $_GET['status'] ?? null;

$user_message = "نتیجه پرداخت شما در حال بررسی است...";
$final_order_status = null;
$final_transaction_status = null;
$order_id_for_log = 'N/A';
$user_telegram_chat_id = null;
$user_bale_chat_id = null;
$user_internal_id = null;
$html_message_for_page = $user_message;
$is_verification_payment = false;
$order_type = 'product'; 

try {
    if (empty($trackId)) {
        throw new Exception("پارامتر trackId از درگاه زیبال دریافت نشد.");
    }

    $transaction = getTransactionByAuthority($trackId);

    if (!$transaction) {
        throw new Exception("خطا: تراکنش پرداخت مرتبط با این شناسه پیگیری یافت نشد (TrackId: {$trackId}).");
    }

    $order_id = $transaction['order_id'];
    $order_id_for_log = $order_id;
    $user_internal_id = $transaction['user_id'];
    $user_telegram_chat_id = $transaction['telegram_chat_id'];
    $user_bale_chat_id = $transaction['bale_chat_id'];
    $amount_rial = $transaction['amount_rial'] ?? 0; 
    
    $current_order_status = $transaction['order_status'] ?? 'unknown';
    $current_transaction_status = $transaction['status'] ?? 'unknown';
    $order_type = $transaction['order_type'] ?? 'product';

    if ($user_internal_id) {
        updateUserField($user_internal_id, 'session_last_activity', date('Y-m-d H:i:s'));
    }

    if ($order_type === 'verification') {
        $is_verification_payment = true;
    }

    if ($current_transaction_status !== 'pending') {
        $current_status_fa = translate_status_to_persian($current_order_status);
        $user_message = "وضعیت پرداخت شما قبلاً مشخص شده است.\nوضعیت سفارش: *{$current_status_fa}*";
        
        if (defined('ERROR_LOG_PATH')) { file_put_contents(ERROR_LOG_PATH, date('Y-m-d H:i:s') . " - Zibal Callback: Transaction {$trackId} already finalized ({$current_transaction_status}).\n", FILE_APPEND); }
        
        $html_message_for_page = strip_tags(str_replace(['`','*'], '', $user_message));
        sendMessageToUser($user_telegram_chat_id, $user_bale_chat_id, $user_message);

    } elseif ($success == 1) { 
        
        $verify_result = verifyZibalPayment((int)$trackId);

        if ($verify_result['success']) {
            $ref_id = $verify_result['ref_id'];
            $card_pan_masked = $verify_result['card_pan'];

            $final_order_status = 'processing';
            $final_transaction_status = 'verified';

            updateOrderStatus($order_id, $final_order_status);

            if ($current_order_status !== 'awaiting_shipping_fee') {
                updateOrderPaymentDetails($order_id, $trackId, $ref_id, $card_pan_masked);
            }

            updateTransactionStatus($trackId, $final_transaction_status, $ref_id, $card_pan_masked);

            logUserActivity($user_internal_id, 'payment_success_zibal', ['order_id' => $order_id, 'ref_id' => $ref_id, 'track_id' => $trackId]);

            if ($is_verification_payment) {
                $user_data = getUserById($user_internal_id);
                $is_partner_customer = ($user_data && isset($user_data['referred_by_user_id']) && $user_data['referred_by_user_id'] !== null);

                sendMessageToUser($user_telegram_chat_id, $user_bale_chat_id, "✅ پرداخت شما برای احراز هویت با موفقیت انجام شد.\n\nشماره پیگیری: `{$ref_id}`");

                if ($is_partner_customer) {
                    updateUserStatus($user_internal_id, 'awaiting_national_id_code');
                    $html_message_for_page = "پرداخت موفق بود. لطفا به ربات بازگردید و کد ملی خود را وارد کنید.";
                    sendMessageToUser($user_telegram_chat_id, $user_bale_chat_id, "لطفا *کد ملی* خود را (۱۰ رقمی و بدون خط تیره) وارد کنید:", null);
                } else {
                    updateUserStatus($user_internal_id, 'awaiting_birth_year');
                    $keyboard_markup = buildBirthYearKeyboard('selectBirth', 0);
                    $html_message_for_page = "پرداخت موفق بود. لطفا به ربات بازگردید و تاریخ تولد خود را انتخاب کنید.";
                    sendMessageToUser($user_telegram_chat_id, $user_bale_chat_id, "لطفا *سال* تولد خود را انتخاب کنید:", $keyboard_markup);
                }

            } else {
                if ($current_order_status === 'awaiting_shipping_fee') {
                    $user_message = "✅ هزینه ارسال سفارش `{$order_id}` با موفقیت پرداخت شد.\n\nشماره پیگیری: `{$ref_id}`\n\nسفارش شما به زودی پردازش خواهد شد.";
                } else {
                    $user_message = "✅ پرداخت شما برای سفارش شماره `{$order_id}` با موفقیت انجام شد.\n\nشماره پیگیری: `{$ref_id}`\n\nسفارش شما به زودی پردازش خواهد شد.";
                }

                sendMessageToUser($user_telegram_chat_id, $user_bale_chat_id, $user_message);
                $html_message_for_page = strip_tags(str_replace(['`','*'], '', $user_message));
            }

            $full_order_details = getOrderDetails($order_id);
            if ($full_order_details) {
                $invoice_text = buildAdminOrderDetailsText($full_order_details);
                
                $admin_message = "✅ *پرداخت موفق زیبال*\n\n" . $invoice_text . "\n\n" .
                                 "🧾 *اطلاعات تراکنش:*\n" .
                                 "RefID: `{$ref_id}`\n" .
                                 "TrackId: `{$trackId}`";
            } else {
                $admin_message = "✅ پرداخت موفق زیبال برای فاکتور `{$order_id}`.\nRefID: `{$ref_id}`";
            }
            
            notifyAdmins($admin_message);

        } else {
            $final_order_status = 'payment_failed';
            $final_transaction_status = 'failed';

            if ($current_order_status !== 'awaiting_shipping_fee') {
                updateOrderStatus($order_id, $final_order_status);
            }
            updateTransactionStatus($trackId, $final_transaction_status);
            
            logUserActivity($user_internal_id, 'payment_verify_failed_zibal', ['order_id' => $order_id, 'track_id' => $trackId, 'zibal_code' => $verify_result['code'], 'msg' => $verify_result['message']]);

            $user_message = "❌ مشکلی در تایید نهایی پرداخت پیش آمد.\nعلت: " . $verify_result['message'];
            
            $payment_page_url = PAYMENT_PAGE_URL . '?order_id=' . $order_id;
            $buttons = [[['text' => '💰 تلاش مجدد برای پرداخت', 'url' => $payment_page_url]]];
            sendMessageToUser($user_telegram_chat_id, $user_bale_chat_id, $user_message, ['inline_keyboard' => $buttons]);
            
            $html_message_for_page = strip_tags(str_replace(['`','*'], '', $user_message));

            notifyAdmins("❌ خطای Verify زیبال برای فاکتور `{$order_id}`.\nMessage: {$verify_result['message']}\nCode: {$verify_result['code']}");
        }

    } else {
        $final_order_status = 'payment_failed';
        $final_transaction_status = ($status == 3) ? 'canceled' : 'failed'; 

        if ($current_order_status !== 'awaiting_shipping_fee') {
            updateOrderStatus($order_id, $final_order_status);
        }
        updateTransactionStatus($trackId, $final_transaction_status);

        logUserActivity($user_internal_id, 'payment_failed_zibal', ['order_id' => $order_id, 'track_id' => $trackId, 'status' => $status]);

        if ($status == 3) {
            $user_message = "❌ پرداخت توسط شما لغو شد.";
        } else {
            $zibal_error_msg = zibalErrorCodeToMessage($status);
            $user_message = "❌ پرداخت ناموفق بود.\nعلت: {$zibal_error_msg} (کد: {$status})";
        }

        $payment_page_url = PAYMENT_PAGE_URL . '?order_id=' . $order_id;
        $buttons = [[['text' => '💰 تلاش مجدد برای پرداخت', 'url' => $payment_page_url]]];
        sendMessageToUser($user_telegram_chat_id, $user_bale_chat_id, $user_message, ['inline_keyboard' => $buttons]);

        $html_message_for_page = strip_tags(str_replace(['`','*'], '', $user_message));
    }

} catch (Exception $e) {
    $error_message = $e->getMessage();
    if (defined('ERROR_LOG_PATH')) { file_put_contents(ERROR_LOG_PATH, date('Y-m-d H:i:s') . " - Zibal Callback CRITICAL: " . $error_message . " | TrackId: {$trackId}\n", FILE_APPEND); }

    $user_message = "❌ خطای سیستمی در پردازش پرداخت زیبال رخ داد. لطفا با پشتیبانی تماس بگیرید.";
    $html_message_for_page = $user_message;

    if ($user_telegram_chat_id || $user_bale_chat_id) {
        sendMessageToUser($user_telegram_chat_id, $user_bale_chat_id, $user_message);
    }
    notifyAdmins("🔥 خطای بحرانی در Zibal Callback 🔥\nError: {$error_message}\nTrackId: `{$trackId}`");
}

echo "<html lang='fa' dir='rtl'><head><title>نتیجه پرداخت</title><meta charset='utf-8'><meta name='viewport' content='width=device-width, initial-scale=1.0'><style>body { font-family: sans-serif; padding: 20px; text-align: center; background-color: #fcfcfc; } .container { max-width: 600px; margin: 0 auto; background: white; padding: 30px; border-radius: 10px; box-shadow: 0 2px 15px rgba(0,0,0,0.05); } p { margin-bottom: 15px; line-height: 1.8; } .success { color: #2e7d32; background-color: #e8f5e9; padding: 15px; border-radius: 8px; border: 1px solid #c8e6c9; } .error { color: #c62828; background-color: #ffebee; padding: 15px; border-radius: 8px; border: 1px solid #ffcdd2; } .info { color: #1565c0; background-color: #e3f2fd; padding: 15px; border-radius: 8px; border: 1px solid #bbdefb; }</style></head><body><div class='container'>";

if (strpos($html_message_for_page, 'موفق') !== false) {
    echo "<div class='success'><h3>✅ پرداخت موفق</h3><p>" . nl2br(htmlspecialchars($html_message_for_page)) . "</p></div>";
} elseif (strpos($html_message_for_page, 'خطا') !== false || strpos($html_message_for_page, 'ناموفق') !== false || strpos($html_message_for_page, 'لغو') !== false) {
    echo "<div class='error'><h3>❌ پرداخت ناموفق</h3><p>" . nl2br(htmlspecialchars($html_message_for_page)) . "</p></div>";
} else {
    echo "<div class='info'><h3>ℹ️ وضعیت پرداخت</h3><p>" . nl2br(htmlspecialchars($html_message_for_page)) . "</p></div>";
}

echo "<p style='margin-top: 30px; color: #666;'>می‌توانید این صفحه را ببندید.</p>";

echo "</div></body></html>";

?>