<?php

if (basename(__FILE__) == basename($_SERVER['SCRIPT_FILENAME'])) {
    die('No direct script access allowed');
}

// --- Setting Queries ---

/**
 * دریافت مقدار یک تنظیم از دیتابیس
 */
function getSetting(string $key, ?string $default = null): ?string {
    try {
        $stmt = pdo()->prepare("SELECT setting_value FROM bot_settings WHERE setting_key = ?");
        $stmt->execute([$key]);
        $result = $stmt->fetchColumn();
        return $result !== false ? $result : $default;
    } catch (PDOException $e) {
        if (defined('ERROR_LOG_PATH')) {
            file_put_contents(ERROR_LOG_PATH, date('Y-m-d H:i:s') . " - DB Error getting setting {$key}: " . $e->getMessage() . "\n", FILE_APPEND);
        }
        return $default;
    }
}

/**
 * ذخیره یا آپدیت مقدار یک تنظیم
 */
function setSetting(string $key, string $value): bool {
    try {
        $stmt = pdo()->prepare("INSERT INTO bot_settings (setting_key, setting_value) VALUES (?, ?) ON DUPLICATE KEY UPDATE setting_value = VALUES(setting_value)");
        return $stmt->execute([$key, $value]);
    } catch (PDOException $e) {
        if (defined('ERROR_LOG_PATH')) {
            file_put_contents(ERROR_LOG_PATH, date('Y-m-d H:i:s') . " - DB Error setting setting {$key}: " . $e->getMessage() . "\n", FILE_APPEND);
        }
        return false;
    }
}

/**
 * دریافت نام درگاه فعال فعلی (پیش‌فرض: zarinpal)
 */
function getActiveGateway(): string {
    return getSetting('active_gateway', 'zarinpal');
}

/**
 * تغییر درگاه فعال
 */
function setActiveGateway(string $gateway): bool {
    if (!in_array($gateway, ['zarinpal', 'zibal'])) {
        return false;
    }
    return setSetting('active_gateway', $gateway);
}

?>