<?php

if (basename(__FILE__) == basename($_SERVER['SCRIPT_FILENAME'])) {
    die('No direct script access allowed');
}

function showAttributeList(array $params, int $chat_id, ?int $message_id, int $user_id, string $platform, array $session_data): void {
    $can_edit = ($message_id !== null);
    
    $attributes = getAttributes();
    
    $text = "⚙️ *مدیریت ویژگی‌ها*\n\n";
    $text .= "ویژگی‌ها، دسته‌های کلی برای ایجاد تنوع در محصولات هستند (مانند: رنگ، سایز، وزن بسته‌بندی).";
    
    $buttons = [];
    if (empty($attributes)) {
        $text .= "\n\n(هیچ ویژگی‌ تعریف نشده است)";
    } else {
        foreach ($attributes as $attr) {
            $buttons[] = [
                ['text' => $attr['name'], 'callback_data' => buildCallbackData('manageAttrValues', ['attr_id' => $attr['id']])],
                ['text' => '❌', 'callback_data' => buildCallbackData('deleteAttrConfirm', ['attr_id' => $attr['id']])]
            ];
        }
    }
    
    $buttons[] = [['text' => '➕ افزودن ویژگی جدید', 'callback_data' => buildCallbackData('addAttrStart')]];
    $buttons[] = [['text' => '🔙 بازگشت به منو اصلی', 'callback_data' => buildCallbackData('adminMainMenu')]];
    
    $reply_markup = ['inline_keyboard' => $buttons];
    
    if ($can_edit) {
        editMessage($chat_id, $message_id, $text, $reply_markup);
    } else {
        sendMessage($chat_id, $text, $reply_markup, $platform);
    }
}

function askForNewAttributeName(array $params, int $chat_id, ?int $message_id, int $user_id, string $platform, array $session_data): void {
    $session_data['state'] = 'awaiting_new_attribute_name';
    updateUserField($user_id, 'session', json_encode($session_data));
    
    $text = "لطفا نام ویژگی جدید را وارد کنید (مثال: رنگ)";
    
    if ($message_id) {
        apiRequest('deleteMessage', ['chat_id' => $chat_id, 'message_id' => $message_id], $platform);
    }
    
    sendMessage(
        $chat_id,
        $text,
        ['keyboard' => [[['text' => 'انصراف و بازگشت به منو']]], 'resize_keyboard' => true],
        $platform
    );
}

function handleNewAttributeName(array $message, int $chat_id, int $user_id, string $platform, array $session_data): void {
    $name = trim($message['text'] ?? '');
    
    if (empty($name)) {
        sendMessage($chat_id, "نام ویژگی نمی‌تواند خالی باشد. لطفا مجددا وارد کنید:", null, $platform);
        return;
    }
    
    $new_id = createAttribute($name);
    
    if ($new_id > 0) {
        sendMessage($chat_id, "✅ ویژگی '{$name}' با موفقیت ایجاد شد.", ['remove_keyboard' => true], $platform);
        updateUserField($user_id, 'session', json_encode(['state' => 'idle']));
        showAttributeList([], $chat_id, null, $user_id, $platform, ['state' => 'idle']);
    } else {
        sendMessage($chat_id, "❌ خطایی در ایجاد ویژگی رخ داد (ممکن است تکراری باشد). لطفا مجددا تلاش کنید.", ['remove_keyboard' => true], $platform);
        updateUserField($user_id, 'session', json_encode(['state' => 'idle']));
        showAdminMainMenu($chat_id, $user_id, $platform);
    }
}

function confirmDeleteAttribute(array $params, int $chat_id, ?int $message_id, int $user_id, string $platform, array $session_data): void {
    $attribute_id = (int)($params['attr_id'] ?? 0);
    $callback_query_id = $GLOBALS['update']['callback_query']['id'] ?? null;

    if ($attribute_id <= 0) {
        if ($callback_query_id) apiRequest('answerCallbackQuery', ['callback_query_id' => $callback_query_id, 'text' => 'خطا: ID نامعتبر.', 'show_alert' => true], $platform);
        return;
    }
    
    $stmt = pdo()->prepare("SELECT name FROM attributes WHERE id = ?");
    $stmt->execute([$attribute_id]);
    $attr_name = $stmt->fetchColumn();

    if (!$attr_name) {
        if ($callback_query_id) apiRequest('answerCallbackQuery', ['callback_query_id' => $callback_query_id, 'text' => 'خطا: ویژگی یافت نشد.', 'show_alert' => true], $platform);
        showAttributeList([], $chat_id, $message_id, $user_id, $platform, $session_data);
        return;
    }

    $text = "⚠️ آیا از حذف ویژگی '{$attr_name}' مطمئن هستید؟\n\n";
    $text .= "توجه: با حذف این ویژگی، تمام مقادیر آن (مانند قرمز، آبی و...) و تمام اتصالات آن به محصولات و ترکیب‌ها نیز حذف خواهد شد. این عمل قابل بازگشت نیست.";

    $buttons = [
        [['text' => '❌ بله، حذف کن', 'callback_data' => buildCallbackData('deleteAttrExecute', ['attr_id' => $attribute_id])]],
        [['text' => '🔙 انصراف', 'callback_data' => buildCallbackData('manageAttributes', ['offset' => 0])]]
    ];
    
    editMessage($chat_id, $message_id, $text, ['inline_keyboard' => $buttons]);
}

function handleExecuteDeleteAttribute(array $params, int $chat_id, ?int $message_id, int $user_id, string $platform, array $session_data): void {
    $attribute_id = (int)($params['attr_id'] ?? 0);
    $callback_query_id = $GLOBALS['update']['callback_query']['id'] ?? null;

    if ($attribute_id <= 0) {
        if ($callback_query_id) apiRequest('answerCallbackQuery', ['callback_query_id' => $callback_query_id, 'text' => 'خطا: ID نامعتبر.', 'show_alert' => true], $platform);
        return;
    }

    try {
        if (deleteAttribute($attribute_id)) {
            if ($callback_query_id) apiRequest('answerCallbackQuery', ['callback_query_id' => $callback_query_id, 'text' => 'ویژگی با موفقیت حذف شد.'], $platform);
        } else {
            if ($callback_query_id) apiRequest('answerCallbackQuery', ['callback_query_id' => $callback_query_id, 'text' => 'خطا: ویژگی یافت نشد یا حذف نشد.', 'show_alert' => true], $platform);
        }
    } catch (PDOException $e) {
        if (defined('ERROR_LOG_PATH')) file_put_contents(ERROR_LOG_PATH, date('Y-m-d H:i:s') . " - DB Error deleting attribute {$attribute_id}: " . $e->getMessage() . "\n", FILE_APPEND);
        if ($callback_query_id) apiRequest('answerCallbackQuery', ['callback_query_id' => $callback_query_id, 'text' => 'خطای دیتابیس هنگام حذف. (احتمالا به محصولی متصل است)', 'show_alert' => true], $platform);
    }
    
    showAttributeList([], $chat_id, $message_id, $user_id, $platform, $session_data);
}

?>