<?php
if (basename(__FILE__) == basename($_SERVER['SCRIPT_FILENAME'])) { die('No direct script access allowed'); }

function showCategoryTree(array $params, int $chat_id, ?int $message_id, int $user_id, string $platform, array $session_data): void {
    $parent_id_param = $params['id'] ?? null;
    $can_edit = ($message_id !== null);
    $parent_id = ($parent_id_param === null || $parent_id_param === 'root') ? null : (int)$parent_id_param;

    $categories = getActiveCategories($parent_id);
    $buttons = [];
    $path_text = "مدیریت دسته‌بندی‌ها (ریشه)";

    if ($parent_id !== null) {
        $path_array = getCategoryPath($parent_id);
        
        // --- START: Corrected Line ---
        $path_names = array_map(function($p) {
             return htmlspecialchars($p['name'] ?? '?');
        }, $path_array);
        // --- END: Corrected Line ---
        
        $path_text = implode(" > ", $path_names);
    }

    $message_text_body = "شما در مسیر *{$path_text}* هستید.\n\n";

     if (empty($categories)) {
        $message_text_body .= "هیچ زیردسته‌ای در این سطح وجود ندارد.";
    } else {
         $message_text_body .= "زیردسته‌ها:";
         foreach ($categories as $category) {
             $cat_name = htmlspecialchars($category['name'] ?? 'نامشخص');
             $cat_id = $category['id'] ?? 0;
             if ($cat_id > 0) {
                 $buttons[] = [['text' => "📁 {$cat_name}", 'callback_data' => buildCallbackData('manageCat', ['id' => $cat_id])]];
             }
        }
    }

    $add_button_parent_id = ($parent_id === null) ? 'root' : $parent_id;
    $buttons[] = [['text' => '➕ افزودن زیردسته در اینجا', 'callback_data' => buildCallbackData('addNestedCat', ['id' => $add_button_parent_id])]];

    if ($parent_id !== null) {
        $parent_cat_info = getCategoryById($parent_id);
        $back_target_id = $parent_cat_info['parent_id'] ?? 'root';
        $buttons[] = [['text' => '⬆️ بازگشت به سطح قبل', 'callback_data' => buildCallbackData('manageCat', ['id' => $back_target_id])]];
    }
     $buttons[] = [['text' => '🔙 بازگشت به منو اصلی', 'callback_data' => buildCallbackData('adminMainMenu')]];

    $reply_markup = ['inline_keyboard' => $buttons];

    if ($can_edit) {
        $current_text = $GLOBALS['update']['callback_query']['message']['text'] ?? $GLOBALS['update']['callback_query']['message']['caption'] ?? null;
        $current_markup_json = isset($GLOBALS['update']['callback_query']['message']['reply_markup']) ? json_encode($GLOBALS['update']['callback_query']['message']['reply_markup']) : null;
        $new_markup_json = json_encode($reply_markup);

        if ($current_text !== $message_text_body || $current_markup_json !== $new_markup_json) {
              editMessage($chat_id, $message_id, $message_text_body, $reply_markup);
        } else {
             $callback_query_id = $GLOBALS['update']['callback_query']['id'] ?? null;
             if ($callback_query_id) { apiRequest('answerCallbackQuery', ['callback_query_id' => $callback_query_id]); }
         }
    } else {
        sendMessage($chat_id, $message_text_body, $reply_markup, $platform);
    }
}

function askForCategoryName(array $params, int $chat_id, ?int $message_id, int $user_id, string $platform, array $session_data): void {
     $parent_id = ($params['id'] === 'root') ? null : (int)($params['id'] ?? null);
     $session_data['state'] = 'awaiting_category_name';
     $session_data['parent_category_id'] = $parent_id;
     updateUserField($user_id, 'session', json_encode($session_data));
     $path_text = "دسته‌بندی اصلی";
     if ($parent_id !== null) {
         $parent_cat = getCategoryById($parent_id);
         if ($parent_cat) {
            $path_text = "زیرمجموعه '{$parent_cat['name']}'";
         } else {
             sendMessage($chat_id, "خطا: دسته‌بندی والد نامعتبر است.", null, $platform);
             updateUserField($user_id, 'session', json_encode(['state' => 'idle']));
             showAdminMainMenu($chat_id, $user_id, $platform);
             return;
         }
     }
     if ($message_id) { apiRequest('deleteMessage', ['chat_id' => $chat_id, 'message_id' => $message_id], $platform); }
     sendMessage($chat_id, "لطفا نام دسته‌بندی جدید را برای '{$path_text}' وارد کنید:", ['keyboard' => [[['text' => 'انصراف و بازگشت به منو']]], 'resize_keyboard' => true, 'one_time_keyboard' => true], $platform);
}

function handleCategoryNameInput(array $message, int $chat_id, int $user_id, string $platform, array $session_data): void {
    $parent_id = $session_data['parent_category_id'] ?? null;
    $message_text = trim($message['text'] ?? '');
    if (!empty($message_text)) {
        $result = createCategory(strip_tags($message_text), $parent_id);
        sendMessage($chat_id, $result['message'], ['remove_keyboard' => true], $platform);
        $new_session_data = ['state' => 'idle'];
        updateUserField($user_id, 'session', json_encode($new_session_data));
        showAdminMainMenu($chat_id, $user_id, $platform);
    } else {
        sendMessage($chat_id, "نام دسته‌بندی نمی‌تواند خالی باشد.", null, $platform);
         sendMessage($chat_id, "👇", ['keyboard' => [[['text' => 'انصراف و بازگشت به منو']]], 'resize_keyboard' => true, 'one_time_keyboard' => true], $platform);
    }
}
?>