<?php

// Prevent direct script access
if (basename(__FILE__) == basename($_SERVER['SCRIPT_FILENAME'])) {
    die('No direct script access allowed');
}

/**
 * Handles the 'setStatus' callback to change an order's status and notify the user.
 */
function handleSetStatus(array $params, int $chat_id, ?int $message_id, int $user_id, string $platform, array $session_data): void {
    $new_status = $params['status'] ?? null;
    $order_id = (int)($params['id'] ?? 0);
    $callback_query_id = $GLOBALS['update']['callback_query']['id'] ?? null;
    $can_edit = ($message_id !== null);


    if ($order_id <= 0 || $new_status === null) {
        if ($callback_query_id) apiRequest('answerCallbackQuery', ['callback_query_id' => $callback_query_id, 'text' => 'خطا: پارامترهای نامعتبر.', 'show_alert' => true], $platform);
        return;
    }

    
    // --- Update Status --- //
    if (updateOrderStatus($order_id, $new_status)) { // Assumes OrderQueries loaded
        if ($callback_query_id) apiRequest('answerCallbackQuery', ['callback_query_id' => $callback_query_id, 'text' => 'وضعیت سفارش به‌روز شد.'], $platform);

        // --- Notify User --- //
        $order_owner = getOrderOwner($order_id); // Assumes OrderQueries loaded
        if ($order_owner) {
            $new_status_fa = translate_status_to_persian($new_status); // Assumes FormattingHelpers loaded
            $user_message = "🔔 وضعیت سفارش شما با شماره `{$order_id}` به *{$new_status_fa}* تغییر کرد.";

            // Customize messages for specific statuses
            switch ($new_status) {
                case 'processing':
                    $user_message = "✅ پرداخت شما برای سفارش `{$order_id}` تایید شد و سفارش در حال پردازش است.";
                    break;
                case 'payment_failed':
                    $user_message = "❌ پرداخت شما برای سفارش `{$order_id}` ناموفق بود. لطفا مجددا تلاش کنید یا با پشتیبانی تماس بگیرید.";
                    break;
                case 'canceled_card_mismatch':
                    $user_message = "❌ سفارش `{$order_id}` به دلیل عدم تطابق کارت بانکی (طبق استعلام) لغو شد.";
                    break;
                case 'refunded':
                    $user_message = "💰 مبلغ سفارش `{$order_id}` به حساب شما بازگشت داده شد (یا فرآیند بازگشت آغاز شد).";
                    break;
                // Add more custom messages as needed
            }
            
            
            // Send message on both platforms if available
            if (!empty($order_owner['telegram_chat_id'])) {
                sendMessage($order_owner['telegram_chat_id'], $user_message, null, 'telegram');
            }
            if (!empty($order_owner['bale_chat_id'])) {
                sendMessage($order_owner['bale_chat_id'], $user_message, null, 'bale');
            }
        }
        
        // --- Refresh Admin View --- //
        if ($can_edit) {
            // Re-fetch order details and update the admin message
            $updated_order = getOrderDetails($order_id);
            if ($updated_order) {
                
                showOrderDetails(['id' => $order_id], $chat_id, $message_id, $user_id, $platform, $session_data);
            } else {
                // Handle error if order couldn't be re-fetched
                 editMessage($chat_id, $message_id, "وضعیت به‌روز شد، اما خطا در بازیابی مجدد اطلاعات سفارش.", null);
            }
        }
        
    } else {
        // DB update failed
        if ($callback_query_id) apiRequest('answerCallbackQuery', ['callback_query_id' => $callback_query_id, 'text' => 'خطا در به‌روزرسانی وضعیت در دیتابیس.', 'show_alert' => true], $platform);
    }
}

?>