<?php

// Prevent direct script access
if (basename(__FILE__) == basename($_SERVER['SCRIPT_FILENAME'])) {
    die('No direct script access allowed');
}

/**
 * Displays the details of a specific order for the admin.
 */
function showOrderDetails(array $params, int $chat_id, ?int $message_id, int $user_id, string $platform, array $session_data): void {
    
    $order_id = (int)($params['id'] ?? 0);
    $callback_query_id = $GLOBALS['update']['callback_query']['id'] ?? null;
    $can_edit = ($message_id !== null);

    if ($order_id <= 0) {
        if ($callback_query_id) apiRequest('answerCallbackQuery', ['callback_query_id' => $callback_query_id, 'text' => 'خطا: شماره 
سفارش نامعتبر.', 'show_alert' => true], $platform);
        // Optionally go back to list
        return;
    }

    $order = getOrderDetails($order_id); // Assumes OrderQueries loaded


    if ($order) {
        $message_text = buildAdminOrderDetailsText($order); // Assumes FormattingHelpers loaded
        
        // Build action buttons
        $action_buttons = [];
        $all_statuses = [
            'awaiting_online_payment', 'payment_failed', 'processing', 'awaiting_shipping_fee',
            'shipped', 'completed', 'canceled', 'refunded'
            // Add 'canceled_card_mismatch' if needed as a manual status change option
        ];
        $status_buttons_row1 = [];
        $status_buttons_row2 = [];
        $count = 0;
        foreach ($all_statuses as $status) {
            if ($status !== $order['status']) {
                $btn = ['text' => '⬅️ ' . translate_status_to_persian($status), 'callback_data' => buildCallbackData('setStatus', ['status' => $status, 'id' => $order_id])];
                if ($count < 4) { // Distribute buttons somewhat evenly
                   $status_buttons_row1[] = $btn;
                } else {
                   $status_buttons_row2[] = $btn;
                }
                 $count++;
            }
        }
        if(!empty($status_buttons_row1)) $action_buttons[] = $status_buttons_row1;
        if(!empty($status_buttons_row2)) $action_buttons[] = $status_buttons_row2;
         
   
        // Contextual buttons
        $context_buttons = [];
        // Allow setting fee if processing
        if ($order['status'] === 'processing') {
             $context_buttons[] = ['text' => '🚚 تعریف هزینه پست', 'callback_data' => buildCallbackData('setShippingFee', ['id' => $order_id])];
        }
        // Allow setting tracking code if relevant
        if (in_array($order['status'], ['processing', 'awaiting_shipping_fee', 'shipped', 'completed'])) {
            $context_buttons[] = ['text' => '📮 ثبت/ویرایش 
کد رهگیری', 'callback_data' => buildCallbackData('setTrackingCode', ['id' => $order_id])];
        }
        if(!empty($context_buttons)) $action_buttons[] = $context_buttons;
        
        // Other actions
        $action_buttons[] = 
[['text' => '👤 مشاهده پروفایل مشتری', 'callback_data' => buildCallbackData('viewUser', ['id' => $order['user_id']])]];
        $action_buttons[] = [['text' => '🔙 بازگشت به لیست سفارشات', 'callback_data' => buildCallbackData($session_data['order_view_type'] === 'referral' ? 'adminOrderReferralPage' : 'adminOrderPage', ['offset' => $session_data['last_order_offset'] ?? 0])]];

        $reply_markup = ['inline_keyboard' => $action_buttons];

         
         if ($can_edit) {
            editMessage($chat_id, $message_id, $message_text, $reply_markup);
        } else {
            sendMessage($chat_id, $message_text, $reply_markup, $platform);
        }
        
    } else {
        if ($callback_query_id) {
           apiRequest('answerCallbackQuery', ['callback_query_id' => $callback_query_id, 'text' => 'خطا: سفارش یافت نشد.', 'show_alert' => true], $platform);
           }
         if ($can_edit) {
   
            editMessage($chat_id, $message_id, "خطا: سفارش با شناسه {$order_id} یافت نشد.", null);
         } else {
             sendMessage($chat_id, "خطا: سفارش با شناسه {$order_id} یافت نشد.", null, $platform);
  
         }
    }
}

?>