<?php

if (basename(__FILE__) == basename($_SERVER['SCRIPT_FILENAME'])) {
    die('No direct script access allowed');
}

function handleRejectPayout(array $params, int $chat_id, ?int $message_id, int $user_id, string $platform, array $session_data): void {
    $request_id = (int)($params['id'] ?? 0);
    $can_edit = ($message_id !== null);
    $callback_query_id = $GLOBALS['update']['callback_query']['id'] ?? null;

    if ($request_id <= 0) {
        if ($callback_query_id) apiRequest('answerCallbackQuery', ['callback_query_id' => $callback_query_id, 'text' => 'خطا: ID درخواست نامعتبر.', 'show_alert' => true], $platform);
        return;
    }

    $request = getPayoutRequestDetails($request_id);
    if (!$request || $request['status'] !== 'pending') {
         if ($callback_query_id) apiRequest('answerCallbackQuery', ['callback_query_id' => $callback_query_id, 'text' => 'خطا: درخواست یافت نشد یا قبلا پردازش شده.', 'show_alert' => true], $platform);
         showPendingPayoutsList(['offset' => 0], $chat_id, $message_id, $platform, $session_data);
         return;
    }

    $session_data['state'] = 'awaiting_payout_rejection_reason';
    $session_data['target_payout_request_id'] = $request_id;
    updateUserField($user_id, 'session', json_encode($session_data));

    $text = "لطفا دلیل رد کردن درخواست تسویه `{$request_id}` را وارد کنید:";
    
    if ($can_edit) {
        editMessage($chat_id, $message_id, $text, null);
    } else {
        sendMessage($chat_id, $text, null, $platform);
    }
    
    sendMessage($chat_id, "👇", ['keyboard' => [[['text' => 'انصراف و بازگشت به منو']]], 'resize_keyboard' => true], $platform);
}


function handlePayoutRejectionReasonInput(array $message, int $chat_id, int $user_id, string $platform, array $session_data): void {
    $request_id = $session_data['target_payout_request_id'] ?? null;
    $reason = trim($message['text'] ?? '');

    if (!$request_id) {
        sendMessage($chat_id, "خطا: شناسه درخواست تسویه یافت نشد. عملیات لغو شد.", ['remove_keyboard' => true], $platform);
        updateUserField($user_id, 'session', json_encode(['state' => 'idle']));
        showAdminMainMenu($chat_id, $user_id, $platform);
        return;
    }

    if (empty($reason)) {
        sendMessage($chat_id, "دلیل رد نمی‌تواند خالی باشد. لطفا دلیل را بنویسید یا انصراف دهید.", null, $platform);
        sendMessage($chat_id, "👇", ['keyboard' => [[['text' => 'انصراف و بازگشت به منو']]], 'resize_keyboard' => true], $platform);
        return;
    }
    
    $reason_sanitized = strip_tags($reason);

    if (rejectPayoutRequest($request_id, $user_id, $reason_sanitized)) {
        sendMessage($chat_id, "✅ درخواست تسویه با موفقیت رد شد و مبلغ به موجودی قابل برداشت همکار بازگشت داده شد.", ['remove_keyboard' => true], $platform);

        $request = getPayoutRequestDetails($request_id);
        if ($request) {
            $partner_user_id = $request['partner_user_id'];
            $partner = getUserById($partner_user_id);
            if ($partner) {
                $partner_message = "❌ *درخواست تسویه شما رد شد.*\n\n";
                $partner_message .= "درخواست شما به مبلغ `" . number_format($request['amount']) . "` تومان توسط ادمین رد شد.\n";
                $partner_message .= "*دلیل:* {$reason_sanitized}\n\n";
                $partner_message .= "مبلغ فوق به موجودی قابل برداشت شما بازگردانده شد.";
                
                if (!empty($partner['telegram_chat_id'])) {
                    sendPushMessage('telegram', $partner['telegram_chat_id'], $partner_message, getCustomerMainMenuKeyboard($partner));
                }
                if (!empty($partner['bale_chat_id'])) {
                    sendPushMessage('bale', $partner['bale_chat_id'], $partner_message, getCustomerMainMenuKeyboard($partner));
                }
            }
        }
        
        deletePayoutRequestMessages($request_id);

    } else {
        sendMessage($chat_id, "❌ خطایی در رد کردن درخواست رخ داد. ممکن است قبلاً پردازش شده باشد.", ['remove_keyboard' => true], $platform);
    }

    updateUserField($user_id, 'session', json_encode(['state' => 'idle']));
    showAdminMainMenu($chat_id, $user_id, $platform);
}

?>