<?php

if (basename(__FILE__) == basename($_SERVER['SCRIPT_FILENAME'])) {
    die('No direct script access allowed');
}

function showPayoutDetails(array $params, int $chat_id, ?int $message_id, int $user_id, string $platform, array $session_data): void {
    $request_id = (int)($params['id'] ?? 0);
    $can_edit = ($message_id !== null);
    $callback_query_id = $GLOBALS['update']['callback_query']['id'] ?? null;

    if ($request_id <= 0) {
        if ($callback_query_id) apiRequest('answerCallbackQuery', ['callback_query_id' => $callback_query_id, 'text' => 'خطا: ID درخواست نامعتبر.', 'show_alert' => true], $platform);
        if ($can_edit) editMessage($chat_id, $message_id, "❌ خطا: ID درخواست نامعتبر است.", null);
        showPendingPayoutsList(['offset' => 0], $chat_id, null, $platform, $session_data);
        return;
    }

    $request = getPayoutRequestDetails($request_id);
    if (!$request) {
         $text = "⚠️ درخواست تسویه با ID `{$request_id}` یافت نشد.";
         if ($callback_query_id) apiRequest('answerCallbackQuery', ['callback_query_id' => $callback_query_id, 'text' => 'خطا: درخواست یافت نشد.', 'show_alert' => true], $platform);
         if ($can_edit) editMessage($chat_id, $message_id, $text, null);
         showPendingPayoutsList(['offset' => 0], $chat_id, null, $platform, $session_data);
         return;
    }

    $text = buildPayoutRequestAdminText($request);
    $buttons = [];

    if ($request['status'] === 'pending') {
         $buttons[] = [['text' => '✅ تایید پرداخت (تکمیل شد)', 'callback_data' => buildCallbackData('approvePayout', ['id' => $request_id])]];
         $buttons[] = [['text' => '❌ رد کردن درخواست', 'callback_data' => buildCallbackData('rejectPayout', ['id' => $request_id])]];
    } else {
        $status_fa = translate_status_to_persian($request['status']);
        $text .= "\n\n*وضعیت:* " . $status_fa;
    }
    
    $buttons[] = [['text' => '🔙 بازگشت به لیست', 'callback_data' => buildCallbackData('viewPayouts', ['offset' => $session_data['last_payout_offset'] ?? 0])]];
    $reply_markup = ['inline_keyboard' => $buttons];

    if ($can_edit) {
        editMessage($chat_id, $message_id, $text, $reply_markup);
    } else {
        sendMessage($chat_id, $text, $reply_markup, $platform);
    }
}

?>