<?php

if (basename(__FILE__) == basename($_SERVER['SCRIPT_FILENAME'])) {
    die('No direct script access allowed');
}

function showPendingRequestsList(array $params, int $chat_id, ?int $message_id, string $platform): void {
    $offset = (int)($params['offset'] ?? 0);
    $limit = 5; 
    $can_edit = ($message_id !== null);
    
    $requests = getPendingAdminRequests($offset, $limit);
    $total = countPendingAdminRequests();
    
    $buttons = [];
    $text = '';

    if (empty($requests) && $offset === 0) {
        $text = "هیچ درخواست در حال انتظاری یافت نشد.";
    } else {
        $page = floor($offset / $limit) + 1;
        $text = "🛎 *لیست درخواست‌های در انتظار* (صفحه {$page}):\n\n";
        
        foreach ($requests as $req) {
            $date_fa = to_jalali_datetime($req['created_at']);
            $user_name = htmlspecialchars($req['first_name'] ?? 'کاربر');
            $user_phone = $req['phone_number'] ? "`{$req['phone_number']}`" : "(`{$req['user_id']}`)";
            $req_type_fa = translateRequestType($req['request_type']);
            
            $buttons[] = [['text' => "{$user_name} - {$req_type_fa} ({$date_fa})", 'callback_data' => buildCallbackData('viewUser', ['id' => $req['user_id']])]];
        }

        $pagination_row = buildPaginationRow('viewPendingRequests', $offset, $limit, $total);
        if (!empty($pagination_row)) {
            $buttons[] = $pagination_row;
        }
    }

    $buttons[] = [['text' => '🔙 بازگشت به منو اصلی', 'callback_data' => buildCallbackData('adminMainMenu')]];
    $reply_markup = ['inline_keyboard' => $buttons];

    if ($can_edit) {
        editMessage($chat_id, $message_id, $text, $reply_markup);
    } else {
        sendMessage($chat_id, $text, $reply_markup, $platform);
    }
}

function translateRequestType(string $type): string {
    $map = [
        'selfie' => 'تایید سلفی',
        'nid' => 'تایید کارت ملی'
    ];
    return $map[$type] ?? $type;
}

?>