<?php
if (basename(__FILE__) == basename($_SERVER['SCRIPT_FILENAME'])) { die('No direct script access allowed'); }

function 
showUserList(array $params, int $chat_id, ?int $message_id, int $user_id, string $platform, array $session_data): void {
    $offset = (int)($params['offset'] ?? 0); 
    $level = $params['level'] ?? 'root';
    $is_admin_level = (bool)($params['admin'] ?? false);

    $limit = defined('ADMIN_USERS_PER_PAGE') ? ADMIN_USERS_PER_PAGE : 5; 
    $can_edit = ($message_id !== null);

    $users_list = [];
    $total_users = 0;
    $text = '';
    $buttons = [];
    
    if ($level === 'root') {
        $text = "👥 *مدیریت کاربران*\n\nلطفا سطح کاربری مورد نظر را انتخاب کنید:";
        $buttons[] = [['text' => '👤 کاربران عادی (همکاران/مشتریان)', 'callback_data' => buildCallbackData('viewUserLevel', ['level' => 'users', 'admin' => 0, 'offset' => 0])]];
        $buttons[] = [['text' => '👑 مدیران', 'callback_data' => buildCallbackData('viewUserLevel', ['level' => 'admins', 'admin' => 1, 'offset' => 0])]];
        $buttons[] = [['text' => '🔙 بازگشت به منو اصلی', 'callback_data' => buildCallbackData('adminMainMenu')]];
    
    } else {
        $users_list = getAllUsers($limit, $offset, $is_admin_level); 
        $total_users = countAllUsers($is_admin_level); 
        $title = $is_admin_level ? '👑 *لیست مدیران*' : '👤 *لیست کاربران عادی*';

        if (empty($users_list) && $offset === 0) {
            $text = $is_admin_level ? "هیچ مدیری یافت نشد." : "هیچ کاربر عادی یافت نشد.";
        } else {
            $page = floor($offset / $limit) + 1; 
            $text = "{$title} (صفحه {$page}):";
            foreach ($users_list as $u) {
                $status_icon = $u['is_active'] ? '✅' : '❌'; 
                
                $user_name = htmlspecialchars($u['first_name'] ?? 'بدون نام');
                $user_phone = $u['phone_number'] ? "`{$u['phone_number']}`" : "(ID: `{$u['id']}`)";
                
                $buttons[] = [['text' => "{$status_icon} {$user_name} - {$user_phone}", 'callback_data' => buildCallbackData('viewUser', ['id' => $u['id']])]];
            }

            
            $pagination_row = buildPaginationRow('viewUserLevel', $offset, $limit, $total_users, ['level' => $level, 'admin' => (int)$is_admin_level]); 
            if (!empty($pagination_row)) {
                $buttons[] = $pagination_row;
            }
        }
        $buttons[] = [['text' => '🔙 بازگشت به سطح‌بندی', 'callback_data' => buildCallbackData('viewUserLevel', ['level' => 'root'])]];
    }
    
    $reply_markup = ['inline_keyboard' => $buttons];

    if ($can_edit) {
        editMessage($chat_id, $message_id, $text, $reply_markup);
    } else {
        sendMessage($chat_id, $text, $reply_markup, $platform);
    }
}
?>