<?php
if (basename(__FILE__) == basename($_SERVER['SCRIPT_FILENAME'])) { die('No direct script access allowed'); }

function askForUserSearchTerm(int $chat_id, int $user_id, string $platform, array $session_data): void {
    $session_data['state'] = 'awaiting_user_search_term';
    updateUserField($user_id, 'session', json_encode($session_data));
    sendMessage($chat_id, 'نام، شماره موبایل یا شناسه کاربر مورد نظر را وارد کنید:', ['keyboard' => [[['text' => 'انصراف و بازگشت به منو']]], 'resize_keyboard' => true], $platform); 
}

function handleUserSearchTerm(array $message, int $chat_id, int $user_id, string $platform, array $session_data): void {
    $search_term = trim($message['text'] ?? ''); 
    if (!empty($search_term)) {
        $users = searchUsers($search_term); 
        if (empty($users)) {
            sendMessage($chat_id, "کاربری با مشخصات `{$search_term}` یافت نشد.", ['remove_keyboard' => true], $platform);
        } else {
            $buttons = [];
            foreach ($users as $u) {
                $status_icon = $u['is_active'] ? '✅' : '❌'; 
                
                $user_name = htmlspecialchars($u['first_name'] ?? 'بدون نام');
                $user_phone = $u['phone_number'] ? "`{$u['phone_number']}`" : "(`{$u['id']}`)";
                $buttons[] = [['text' => "{$status_icon} {$user_name} - {$user_phone}", 'callback_data' => buildCallbackData('viewUser', ['id' => $u['id']])]];
            }
            $buttons[] = [['text' => '🔙 بازگشت به منو اصلی', 'callback_data' => buildCallbackData('adminMainMenu')]];
            sendMessage($chat_id, "👥 نتایج جستجو برای `{$search_term}`:", ['inline_keyboard' => $buttons, 'remove_keyboard' => true], $platform);
        }
        $new_session_data = ['state' => 'idle']; 
        updateUserField($user_id, 'session', json_encode($new_session_data)); 
    } else {
        sendMessage($chat_id, "لطفا عبارت جستجو را وارد کنید.", null, $platform);
        sendMessage($chat_id, "👇", ['keyboard' => [[['text' => 'انصراف و بازگشت به منو']]], 'resize_keyboard' => true], $platform);
    }
}
?>