<?php

if (basename(__FILE__) == basename($_SERVER['SCRIPT_FILENAME'])) { die('No direct script access allowed'); }

function showUserDetails(array $params, int $chat_id, ?int $message_id, int $admin_user_id, string $platform, array $session_data): void {
     $target_user_id = (int)($params['id'] ?? 0);
     $can_edit = ($message_id !== null);

     if ($target_user_id <= 0) {
         if ($can_edit) { editMessage($chat_id, $message_id, "خطا: شناسه کاربر نامعتبر است.", null, false, $platform); }
     else { sendMessage($chat_id, "خطا: شناسه کاربر نامعتبر است.", null, $platform); }
        return;
    }

    $user_details = getUserDetailsForAdmin($target_user_id);
    if (!$user_details) {
         if($can_edit) {
            editMessage($chat_id, $message_id, "کاربر یافت نشد.", null, false, $platform);
         } else {
             
             sendMessage($chat_id, "کاربر یافت نشد.", null, $platform);
            }
        return;
    }

    $status_text = $user_details['is_active'] ? 'فعال ✅' : 'غیرفعال ❌';
    $cart_count = count($user_details['cart'] ?? []);
    $order_count_product = countOrdersByUser($target_user_id, 'product');
    $order_count_invoice = countOrdersByUser($target_user_id, 'invoice');
    $card_count = count($user_details['cards'] ?? []);
    
    $tg_id_text = $user_details['telegram_user_id'] ? "`{$user_details['telegram_user_id']}`" : "ندارد";
    $bale_id_text = $user_details['bale_user_id'] ? "`{$user_details['bale_user_id']}`" : "ندارد";
    
    $text = "*مشخصات کاربر: {$user_details['first_name']}*\n";
    $text .= "------------------------------------\n";
    $text .= "🔹 شناسه داخلی: `{$target_user_id}`\n";
    $text .= "🔹 شناسه تلگرام: {$tg_id_text}\n";
    $text .= "🔹 شناسه بله: {$bale_id_text}\n";
    $text .= "🔹 شماره تماس: `{$user_details['phone_number']}`\n";
    $text .= "🔹 کد ملی: `{$user_details['national_id_code']}`\n";
    $text .= "🔹 تاریخ تولد: `{$user_details['birth_date']}`\n";
    $text .= "🔹 وضعیت حساب: *{$status_text}*\n";
    $text .= "🔹 وضعیت احراز هویت: `{$user_details['status']}`\n";
    $text .= "------------------------------------\n";
    $text .= "🛒 آیتم در سبد خرید: `{$cart_count}`\n";
    $text .= "📦 سفارشات محصول: `{$order_count_product}`\n";
    $text .= "🧾 فاکتورهای آزاد: `{$order_count_invoice}`\n";
    $text .= "💳 کارت‌های ثبت شده: `{$card_count}`\n";


    if (!empty($user_details['admin_rejection_reason'])) {
       $text .= "\n*آخرین دلیل رد:* " . htmlspecialchars($user_details['admin_rejection_reason']);
    }

    $toggle_text = $user_details['is_active'] ? 'غیرفعال کردن ❌' : 'فعال کردن ✅';
    $buttons = [
        [['text' => 'ارسال پیام مستقیم ✍️', 'callback_data' => buildCallbackData('messageUser', ['id' => $target_user_id])]],
        [['text' => $toggle_text, 'callback_data' => buildCallbackData('toggleUserStatus', ['id' => $target_user_id])]],
        
        [['text' => 'مشاهده لاگ فعالیت‌ها 📜', 'callback_data' => buildCallbackData('viewLogs', ['id' => $target_user_id, 'offset' => 0])]]
    ];

    $nid_button_needed = !empty($user_details['national_id_data']);
    $selfie_button_needed = !empty($user_details['selfie_data']);

    $file_buttons = [];
    if ($nid_button_needed) {
        $file_buttons[] = ['text' => '📸 مشاهده (چهره و کارت ملی)', 
        'callback_data' => buildCallbackData('viewUserFile', ['id' => $target_user_id, 'type' => 'nid'])];
    }
    if ($selfie_button_needed) {
        $file_buttons[] = ['text' => '🤳 مشاهده سلفی (قرارداد)', 'callback_data' => buildCallbackData('viewUserFile', ['id' => $target_user_id, 'type' => 'selfie'])];
         
       
    }
    if (!empty($file_buttons)) {
        $buttons[] = $file_buttons;
    }

    
      if($card_count > 0) {
        
        $buttons[] = [['text' => '💳 مشاهده کارت‌های کاربر', 'callback_data' => buildCallbackData('viewUserCardsAdmin', ['id' => $target_user_id])]];
    }
    
    
         if ($user_details['status'] === 'awaiting_admin_selfie_approval') {
             $buttons[] = [
                 ['text' 
                 => '✅ تایید نهایی', 'callback_data' => buildCallbackData("approveSelfie", ['uid' => $target_user_id, 'req_id' => $params['req_id'] ?? 0])]
             ];
             
             $buttons[] = [
                 ['text' => '❌ رد (چهره/کارت)', 'callback_data' => buildCallbackData("rejectSelfie", ['uid' => $target_user_id, 'step' => 'nid_photo_only', 'req_id' => $params['req_id'] ?? 0])],
                 ['text' => '❌ رد (قرارداد)', 'callback_data' => buildCallbackData("rejectSelfie", ['uid' => $target_user_id, 'step' => 'selfie_only', 'req_id' => $params['req_id'] ?? 0])]
             ];
             
             $buttons[] = [
                 ['text' => '❌ رد کامل (شروع مجدد)', 'callback_data' => buildCallbackData("rejectSelfie", ['uid' => $target_user_id, 'step' => 'complete_reject', 'req_id' => $params['req_id'] ?? 0])]
             ];
         }
         
         
         if ($user_details['status'] === 'awaiting_national_id_code' && $nid_button_needed) {
             $buttons[] = [
                 ['text' => '❌ رد کامل (شروع مجدد)', 'callback_data' => buildCallbackData("rejectSelfie", ['uid' => $target_user_id, 'step' => 'complete_reject', 'req_id' => $params['req_id'] ?? 0])]
             ];
         }
         
     
    
    
    $buttons[] = [['text' => '🔙 بازگشت به لیست کاربران', 'callback_data' => buildCallbackData('viewUserLevel', ['level' => ($user_details['is_admin'] ? 'admins' : 'users'), 'admin' => (int)$user_details['is_admin'], 'offset' => $session_data['last_user_offset'] ?? 0])]];
    
       
       
         
       if ($can_edit) {
        editMessage($chat_id, $message_id, $text, ['inline_keyboard' => $buttons], false, $platform);
    } else {
        sendMessage($chat_id, $text, ['inline_keyboard' => $buttons], $platform);
   }
 }


 function handleToggleUserStatus(array $params, int $chat_id, ?int $message_id, int $user_id, string $platform, array $session_data): void {
     $target_user_id = (int)($params['id'] ?? 0);
      $can_edit = ($message_id !== null);
     $callback_query_id = $GLOBALS['update']['callback_query']['id'] ?? null;

     if ($target_user_id > 0) {
         $stmt = pdo()->prepare("SELECT is_active FROM users WHERE id = ?");
         $stmt->execute([$target_user_id]);
         $user_to_toggle = $stmt->fetch();
         if ($user_to_toggle) {
             $new_status = !$user_to_toggle['is_active'];
             toggleUserActiveStatus($target_user_id, $new_status);
             if ($callback_query_id) { apiRequest('answerCallbackQuery', ['callback_query_id' => $callback_query_id, 'text' => 'وضعیت کاربر با موفقیت تغییر کرد.']); }
         
         showUserDetails(['id' => $target_user_id], $chat_id, $message_id, $user_id, $platform, $session_data);
         } else {
              if ($callback_query_id) { apiRequest('answerCallbackQuery', ['callback_query_id' => $callback_query_id, 'text' => 'خطا: کاربر یافت نشد.', 'show_alert' => true]); }
         }
     }
 }

function showUserLogs(array $params, int $chat_id, ?int $message_id, string $platform, array $session_data): void {
     $target_user_id = (int)($params['id'] ?? 0);
     $offset = (int)($params['offset'] ?? 0);
     $limit = 10;
     $can_edit = ($message_id !== null);

     if ($target_user_id > 0 && $can_edit) {
         $logs = getUserActivityLogs($target_user_id, $limit, $offset);
         
        $total_logs = 0;
         try { $total_logs = (int)pdo()->query("SELECT COUNT(*) FROM user_activity_logs WHERE user_id = $target_user_id")->fetchColumn(); } catch(Exception $e) {}

         
         $stmt = pdo()->prepare("SELECT first_name FROM users WHERE id=?");
         $stmt->execute([$target_user_id]);
         $target_user_name = $stmt->fetchColumn() ?: "کاربر {$target_user_id}";
         
         $text = '';
         $page = floor($offset / $limit) + 1;

         if (empty($logs) && $offset === 0) {
            
            $text = "هیچ فعالیتی برای کاربر '{$target_user_name}' ثبت نشده است.";
         } else {
             $text = "📜 *فعالیت‌های کاربر '{$target_user_name}'* (صفحه {$page}):\n\n";
             foreach ($logs as $log) {
                 $date = to_jalali_datetime($log['created_at']);
                 $details_text = '';
                 if ($log['details']) {
                    
                     
                       $decoded = json_decode($log['details'], true);
                    
                    if (is_array($decoded)) {
                        $details_text = " (" . mb_substr(json_encode($decoded, JSON_UNESCAPED_UNICODE | JSON_INVALID_UTF8_SUBSTITUTE), 0, 100) . ")";
                        
                    } else {
 
                        $details_text = " (`" . mb_substr($log['details'], 0, 100) . "`)";
                       }
            }
                 $action_safe = str_replace(['_', '*', '`', '['], ['\\_', '\\*', '\\`', '\\['], $log['action']);
                 $details_safe = str_replace(['_', '*', '`', '['], ['\\_', '\\*', '\\`', '\\['], $details_text);
                 
$text .= "- *{$action_safe}*{$details_safe} - {$date}\n";
             }
      }
         $buttons = [];
         
         $pagination_row = buildPaginationRow('viewLogs', $offset, $limit, $total_logs, ['id' => $target_user_id]);
          if (!empty($pagination_row)) {
       $buttons[] = $pagination_row;
         }
         
         $buttons[] = [['text' => '🔙 بازگشت به پروفایل کاربر', 'callback_data' => buildCallbackData('viewUser', ['id' => $target_user_id])]];
         editMessage($chat_id, $message_id, $text, ['inline_keyboard' => $buttons], false, $platform);
     }
}

function showUserFile(array $params, int $chat_id, ?int $message_id, string $platform, ?string $callback_query_id): void {
     $target_user_id = (int)($params['id'] ?? 0);
      $file_type = $params['type'] ?? null;
      
      if ($target_user_id > 0 && $file_type && $message_id) {
         
         $target_user_object = getUserById($target_user_id);
         if (!$target_user_object) {
            if ($callback_query_id) { apiRequest('answerCallbackQuery', ['callback_query_id' => $callback_query_id, 'text' => 'خطا: کاربر یافت نشد.', 'show_alert' => true], $platform); }
            return;
         }

         $file_data = getUserVerificationFileData($target_user_id, $file_type);

         if ($file_data) {
             $file_caption_prefix = '';
             $file_extension = 'jpg';
             
             
             if ($file_type === 'nid') {
                 $file_caption_prefix = "📸 (چهره و کارت ملی) کاربر '{$target_user_object['first_name']}'";
             } elseif ($file_type === 'selfie') {
                 $file_caption_prefix = "🤳 سلفی (قرارداد) کاربر '{$target_user_object['first_name']}'";
             }
             
             $tmp_path = TMP_UPLOAD_DIR . '/' . uniqid('verify_', true) . '.' . $file_extension;
             
             
             if (file_put_contents($tmp_path, $file_data) === false) {
                 unset($file_data);
                 if ($callback_query_id) { apiRequest('answerCallbackQuery', ['callback_query_id' => $callback_query_id, 'text' => 'خطا در ایجاد فایل موقت.', 'show_alert' => true], $platform); }
                 if (defined('ERROR_LOG_PATH')) { file_put_contents(ERROR_LOG_PATH, date('Y-m-d H:i:s') . " - Error creating temp file for user file: {$tmp_path}\n", FILE_APPEND); }
                 return;
             }
             unset($file_data);
              
              $buttons = [[['text' => '🔙 بازگشت به پروفایل کاربر', 'callback_data' => buildCallbackData('viewUser', ['id' => $target_user_id])]]];
             
             sendPhotoWithButtons($chat_id, new CURLFile(realpath($tmp_path)), $file_caption_prefix, $buttons, $platform);
             
             
             if ($callback_query_id) {
                 @apiRequest('answerCallbackQuery', ['callback_query_id' => $callback_query_id], $platform);
             }
             
             @unlink($tmp_path);

          } else {
             if ($callback_query_id) { apiRequest('answerCallbackQuery', ['callback_query_id' => $callback_query_id, 'text' => "⚠️ فایل یافت نشد یا قابل رمزگشایی نیست.", 'show_alert' => true], $platform); }
         }
     }
}

function showUserCardsAdmin(array $params, int $chat_id, ?int $message_id, string $platform, array $session_data): void {
  $target_user_id = (int)($params['id'] ?? 0);

     $can_edit = ($message_id !== null);

     if ($target_user_id > 0 && $can_edit) {
          $cards = getUserCards($target_user_id);
          
$stmt = pdo()->prepare("SELECT first_name FROM users WHERE id = ?");
          
          $stmt->execute([$target_user_id]); $target_user_name = $stmt->fetchColumn() ?: "کاربر {$target_user_id}";
          $text = "💳 *کارت‌های بانکی ثبت شده برای {$target_user_name}:*\n\n";

          if (empty($cards)) {
         $text .= "هیچ کارتی برای این کاربر ثبت نشده است.";
          } else {

              foreach ($cards as $card) {
                 $text .= "- `" . ($card['card_number_masked'] ?? '****') . "`\n";
              }
          }
          $buttons = [[['text' => '🔙 بازگشت به پروفایل کاربر', 'callback_data' => buildCallbackData('viewUser', ['id' => $target_user_id])]]];
          editMessage($chat_id, $message_id, $text, ['inline_keyboard' => $buttons], false, $platform);
     }
}

function handleApproveSelfie(array $params, int $chat_id, ?int $message_id, int $user_id, string $platform, ?string $callback_query_id, array $session_data): void {
      $target_user_id = (int)($params['uid'] ?? 0);
      $request_id = (int)($params['req_id'] ?? 0);
      $can_edit = ($message_id !== null);
     $original_caption = $GLOBALS['update']['callback_query']['message']['caption'] ?? ($GLOBALS['update']['callback_query']['message']['text'] ?? '');
          $is_photo_message = isset($GLOBALS['update']['callback_query']['message']['photo']);

      if ($target_user_id <= 0) {
           if ($callback_query_id) { apiRequest('answerCallbackQuery', ['callback_query_id' => $callback_query_id, 'text' => 'خطا: شناسه کاربر نامعتبر.', 'show_alert' => true]); }
           
           return;
      }
      
     $target_user_object = getUserById($target_user_id);

     if (!$target_user_object) {
         if ($callback_query_id) { apiRequest('answerCallbackQuery', ['callback_query_id' => $callback_query_id, 'text' => 'خطا: کاربر یافت نشد.', 'show_alert' => true]); }
         return;
     }
     
     $pending_request = null;
     
     if ($request_id > 0) {
        $pending_request = getPendingRequestById($request_id);
     } else {
        $pending_request = findPendingRequestByInternalUserId($target_user_id, 'selfie');
     }

     if (!$pending_request || $pending_request['status'] !== 'pending' || $pending_request['request_type'] !== 'selfie') {
          if ($callback_query_id) { apiRequest('answerCallbackQuery', ['callback_query_id' => $callback_query_id, 'text' => 'وضعیت کاربر قبلا تغییر کرده یا درخواستی یافت نشد.', 'show_alert' => true]); }
          if ($can_edit) { editMessage($chat_id, $message_id, $original_caption . "\n\n---\n*وضعیت:* " . translate_status_to_persian($target_user_object['status']), null, $is_photo_message, $platform); }
         return;
     }
     
     
     if (updatePendingRequestStatus($pending_request['id'], 'processed', $user_id)) {
        updateUserStatus($target_user_id, 'identity_verified');
         $user_message = "✅ احراز هویت شما با موفقیت تایید شد.\n\nاکنون می‌توانید از تمام امکانات ربات استفاده کنید.";
         
         $mainMenuKeyboard = getCustomerMainMenuKeyboard($target_user_object);
         
         if (!empty($target_user_object['telegram_chat_id'])) { sendPushMessage('telegram', $target_user_object['telegram_chat_id'], $user_message, $mainMenuKeyboard); }
         if (!empty($target_user_object['bale_chat_id'])) { sendPushMessage('bale', $target_user_object['bale_chat_id'], $user_message, $mainMenuKeyboard); }
        
 
         if ($callback_query_id) { apiRequest('answerCallbackQuery', ['callback_query_id' => $callback_query_id, 'text' => 'احراز هویت با موفقیت تایید شد.'], $platform); }
         
         
         
         
         updateAdminRequestMessages($pending_request['id'], $original_caption, "\n\n---\n*وضعیت: ✅ تایید شده توسط {$user['first_name']}*");
         
          
         showUserDetails(['id' => $target_user_id], $chat_id, $message_id, $user_id, $platform, $session_data);
         
      } else {

         if ($callback_query_id) { apiRequest('answerCallbackQuery', ['callback_query_id' => $callback_query_id, 'text' => 'خطا در پردازش. ممکن است مدیر دیگری همزمان اقدام کرده باشد.', 'show_alert' => true], $platform); }
         if ($can_edit) { editMessage($chat_id, $message_id, $original_caption . "\n\n---\n*وضعیت:* " . translate_status_to_persian($target_user_object['status']), null, $is_photo_message, $platform); }
     }
}

function askForRejectionReason(array $params, int $chat_id, ?int $message_id, int $user_id, string $platform, array $session_data): void {
      $target_user_id = (int)($params['uid'] ?? 0);
       $step_to_reject = $params['step'] ?? 'selfie_only'; 
            $request_id = (int)($params['req_id'] ?? 0);
      $can_edit = ($message_id !== null);
      $callback_query_id = $GLOBALS['update']['callback_query']['id'] ?? null;

     if ($target_user_id <= 0) {
           if ($callback_query_id) { apiRequest('answerCallbackQuery', ['callback_query_id' => $callback_query_id, 'text' => 'خطا: شناسه کاربر نامعتبر.', 'show_alert' => true]); }
           return;
     }

     $target_user_object = getUserById($target_user_id);
      if (!$target_user_object) {
           if ($callback_query_id) { apiRequest('answerCallbackQuery', ['callback_query_id' => $callback_query_id, 'text' => 'خطا: کاربر یافت نشد.', 'show_alert' => true]); }
           return;
      }

      $request_type_to_find = 'selfie'; 
      if ($step_to_reject === 'complete_reject') {
          $pending_nid = findPendingRequestByInternalUserId($target_user_id, 'nid');
          if ($pending_nid && $pending_nid['status'] === 'pending') {
              $request_type_to_find = 'nid';
              $request_id = $pending_nid['id'];
          } else {
              $pending_selfie = findPendingRequestByInternalUserId($target_user_id, 'selfie');
              if ($pending_selfie && $pending_selfie['status'] === 'pending') {
                 $request_type_to_find = 'selfie';
                  $request_id = $pending_selfie['id'];
              } else {
                  $request_type_to_find = ($target_user_object['status'] === 'awaiting_national_id_code') ? 'nid' : 'selfie';
            }
          }
      } elseif ($step_to_reject === 'selfie_only') {
           $request_type_to_find = 'selfie';
      }
      
       $pending_request = null;
      if ($request_id > 0) {
          $pending_request = getPendingRequestById($request_id);
      } else {
          $pending_request = findPendingRequestByInternalUserId($target_user_id, $request_type_to_find);
      }
      
      if (!$pending_request || $pending_request['status'] !== 'pending') {
            if ($callback_query_id) { apiRequest('answerCallbackQuery', ['callback_query_id' => $callback_query_id, 'text' => 'وضعیت کاربر قبلا تغییر کرده یا درخواستی یافت نشد.', 'show_alert' => true]); }
            return;
      }
      
      
$session_data['state'] = 'awaiting_admin_rejection_reason';
     $session_data['target_user_id'] = $target_user_object['id'];
           $session_data['rejection_step'] = $step_to_reject; 
           $session_data['rejection_request_id'] = $pending_request['id'];
     $session_data['target_user_telegram_chat_id'] = $target_user_object['telegram_chat_id'];
     $session_data['target_user_bale_chat_id'] = $target_user_object['bale_chat_id'];
     updateUserField($user_id, 'session', json_encode($session_data));
     
     
     
     if ($can_edit) {
         $original_caption = $GLOBALS['update']['callback_query']['message']['caption'] ?? ($GLOBALS['update']['callback_query']['message']['text'] ?? '');
     
         $is_photo_message = isset($GLOBALS['update']['callback_query']['message']['photo']);
         editMessage($chat_id, $message_id, $original_caption . "\n\n---\n*در انتظار دلیل رد...*", null, $is_photo_message, $platform);
     }

     sendMessage($chat_id, "لطفا دلیل رد شدن تصویر کاربر `{$target_user_object['id']}` را در پیام بعدی ارسال کنید:", ['keyboard' => [[['text' => 'انصراف و بازگشت به منو']]], 'resize_keyboard' => true], $platform);
}

function handleRejectionReasonInput(array $message, int $chat_id, int $user_id, string $platform, array $session_data): void {
     $message_text = trim($message['text'] ?? '');
     if (isset($session_data['target_user_id']) && !empty($message_text)) {
         $target_user_id = $session_data['target_user_id'];
         $reason = strip_tags($message_text);
         
               
         $step_rejected = $session_data['rejection_step'] ?? 'selfie_only'; 
                   $request_id = $session_data['rejection_request_id'] ?? 0;
         
         $pending_request = getPendingRequestById($request_id);
         
         if (!$pending_request || $pending_request['status'] !== 'pending' || $pending_request['user_id'] != $target_user_id) {
            sendMessage($chat_id, "❌ خطا: درخواست در حال انتظار یافت نشد (ممکن است قبلاً پردازش شده باشد).", ['remove_keyboard' => true], $platform);
              updateUserField($user_id, 'session', json_encode(['state' => 'idle']));
              showAdminMainMenu($chat_id, $user_id, $platform);
             
         return;
         }

         
         if (updatePendingRequestStatus($pending_request['id'], 'processed', $user_id)) {
            updateUserField($target_user_id, 'admin_rejection_reason', $reason);
            
            $target_telegram_chat_id = $session_data['target_user_telegram_chat_id'] ?? null;
            $target_bale_chat_id = $session_data['target_user_bale_chat_id'] ?? null;
            $user_message = "";
            $admin_notification = "";

            if ($step_rejected === 'nid_photo_only') {
                $status_to_revert = 'awaiting_national_id_photo';
                updateUserStatus($target_user_id, $status_to_revert); 
                
                updateUserField($target_user_id, 'national_id_data', null); 

                $user_message = "❌ تصویر (چهره و کارت ملی) شما رد شد.\n\n*دلیل:* {$reason}\n\nلطفا مجددا تصویر صحیح را ارسال کنید. (برای ادامه /start را بزنید)";
                $admin_notification = "✅ درخواست کاربر رد شد و به مرحله ارسال مجدد (چهره و کارت ملی) بازگردانده شد.";
                updateAdminRequestMessages($pending_request['id'], null, "\n\n---\n*وضعیت: ❌ رد (چهره/کارت) توسط {$user['first_name']}*\n*دلیل:* {$reason}");

            } elseif ($step_rejected === 'selfie_only') {
                $status_to_revert = 'awaiting_selfie';
                updateUserStatus($target_user_id, $status_to_revert);
                
                updateUserField($target_user_id, 'selfie_data', null); 

                $user_message = "❌ تصویر قرارداد شما رد شد.\n\n*دلیل:* {$reason}\n\nلطفا مجددا تصویر صحیح را ارسال کنید. (برای ادامه /start را بزنید)";
                $admin_notification = "✅ درخواست قرارداد کاربر رد شد و به مرحله ارسال مجدد سلفی/قرارداد بازگردانده شد.";
                updateAdminRequestMessages($pending_request['id'], null, "\n\n---\n*وضعیت: ❌ رد مقطعی توسط {$user['first_name']}*\n*دلیل:* {$reason}");

            } else { 
                resetUser($target_user_id); 
                updateUserStatus($target_user_id, 'awaiting_phone'); 
                
                $user_message = "❌ احراز هویت شما رد شد.\n\n*دلیل:* {$reason}\n\nلطفا با ارسال /start مجددا احراز هویت کنید.";
                $admin_notification = "✅ کاربر به طور کامل رد شد و به مرحله اول (awaiting_phone) بازگردانده شد.";
                updateAdminRequestMessages($pending_request['id'], null, "\n\n---\n*وضعیت: ❌ رد کامل توسط {$user['first_name']}*\n*دلیل:* {$reason}");
            }
            
            if ($target_telegram_chat_id) { sendPushMessage('telegram', $target_telegram_chat_id, $user_message, null); }
            if ($target_bale_chat_id) { sendPushMessage('bale', $target_bale_chat_id, $user_message, null); }

           sendMessage($chat_id, $admin_notification, ['remove_keyboard' => true], $platform);
           
          
       
        } else {
             sendMessage($chat_id, "❌ خطا در پردازش. ممکن است مدیر دیگری همزمان اقدام کرده باشد.", ['remove_keyboard' => true], $platform);

         }
         
         
         $new_session_data = ['state' => 'idle']; 
        updateUserField($user_id, 'session', json_encode($new_session_data));
     
    showAdminMainMenu($chat_id, $user_id, $platform); 

     } elseif (empty($message_text)) {
          sendMessage($chat_id, "دلیل رد نمی‌تواند خالی باشد. لطفا دلیل را بنویسید یا انصراف دهید.", null, $platform);
          
          
     sendMessage($chat_id, "👇", ['keyboard' => [[['text' => 'انصراف و بازگشت به منو']]], 'resize_keyboard' => true], $platform);
     } else {
          sendMessage($chat_id, "خطا: اطلاعات کاربر هدف یافت نشد. عملیات لغو شد.", ['remove_keyboard' => true], $platform);
          $new_session_data = ['state' => 'idle'];
          
  updateUserField($user_id, 'session', json_encode($new_session_data));
          showAdminMainMenu($chat_id, $user_id, $platform);
     }
}

?>