<?php
if (basename(__FILE__) == basename($_SERVER['SCRIPT_FILENAME'])) {
    die('No direct script access allowed');
}

function askForCardNumber(array $params, int $chat_id, ?int $message_id, int $user_id, string $platform): void {
    $session_data = ['state' => 'awaiting_new_card_number'];
    updateUserField($user_id, 'session', json_encode($session_data));

    $prompt = "لطفا شماره ۱۶ رقمی کارت بانکی خود را (که به نام خودتان است) وارد کنید:";
    $cancel_keyboard = ['keyboard' => [[['text' => 'انصراف']]], 'resize_keyboard' => true, 'one_time_keyboard' => true];

    if ($message_id) {
        editMessage($chat_id, $message_id, $prompt, null);
    } else {
        sendMessage($chat_id, $prompt, null, $platform);
    }
    
    sendMessage($chat_id, "👇", $cancel_keyboard, $platform);
}

function handleCardNumberInput(array $message, int $chat_id, int $user_id, string $platform, array $session_data, array $user): void {
    $card_number_input = trim($message['text'] ?? '');
    $user = $GLOBALS['user'];

    if (!validateCardNumberFormat($card_number_input)) {
         sendMessage($chat_id, "❌ شماره کارت نامعتبر است. لطفا یک شماره ۱۶ رقمی صحیح (بدون فاصله یا خط تیره) وارد کنید یا انصراف دهید.", null, $platform);
         sendMessage($chat_id, "👇", ['keyboard' => [[['text' => 'انصراف']]], 'resize_keyboard' => true, 'one_time_keyboard' => true], $platform);
         return;
    }

    $card_number_clean = preg_replace('/\D/', '', convertPersianToEnglishDigits($card_number_input));

    
    if (empty($user['national_id_code']) || empty($user['birth_date'])) {
         sendMessage($chat_id, "❌ خطا: اطلاعات کد ملی یا تاریخ تولد شما برای استعلام کارت یافت نشد. لطفا ابتدا پروفایل خود را تکمیل کنید.", ['remove_keyboard' => true], $platform);
         updateUserField($user_id, 'session', json_encode(['state' => 'idle']));
         showCustomerMainMenu($chat_id, $user_id, $platform, $user); // <--- اصلاح: پاس دادن $user
         return;
    }

    sendMessage($chat_id, "⏳ در حال بررسی تطابق اطلاعات کارت با کد ملی و تاریخ تولد شما...", ['remove_keyboard' => true], $platform);
    $match_result = checkCardMatch($user['national_id_code'], $user['birth_date'], $card_number_clean);

    if ($match_result === true) {
        if (addUserCard($user_id, $card_number_clean)) {
             
             // --- شروع اصلاح ---
             // به جای ارسال پیام با markup null، منوی اصلی را ارسال می‌کنیم
             $mainMenuKeyboard = getCustomerMainMenuKeyboard($user); // <--- اصلاح: پاس دادن $user
             sendMessage($chat_id, "✅ کارت بانکی شما با موفقیت تایید و ذخیره شد.", $mainMenuKeyboard, $platform);
             // --- پایان اصلاح ---
             
             updateUserField($user_id, 'session', json_encode(['state' => 'idle']));
             
             // حالا لیست کارت‌ها را در یک پیام جداگانه (با کیبورد شیشه‌ای) نشان می‌دهیم
             // کاربر اکنون هم منوی اصلی را دارد و هم لیست کارت‌ها را می‌بیند
             showCardList([], $chat_id, null, $user_id, $platform, $user);
             
        } else {
             sendMessage($chat_id, "❌ خطایی در ذخیره کارت رخ داد. لطفا دوباره تلاش کنید یا با پشتیبانی تماس بگیرید.", ['remove_keyboard' => true], $platform);
             updateUserField($user_id, 'session', json_encode(['state' => 'idle']));
             showCustomerMainMenu($chat_id, $user_id, $platform, $user); // <--- اصلاح: پاس دادن $user
        }
    } elseif ($match_result === false) {
        sendMessage($chat_id, "❌ اطلاعات کارت وارد شده با کد ملی یا تاریخ تولد شما مطابقت ندارد. کارت اضافه نشد.\nلطفا کارت صحیح را وارد کنید یا انصراف دهید.", null, $platform);
        sendMessage($chat_id, "👇", ['keyboard' => [[['text' => 'انصراف']]], 'resize_keyboard' => true, 'one_time_keyboard' => true], $platform);
    } else { 
        sendMessage($chat_id, "❌ خطایی در استعلام تطابق کارت رخ داد. ممکن است سرویس موقتا در دسترس نباشد. لطفا لحظاتی بعد دوباره تلاش کنید یا انصراف دهید.", null, $platform);
        sendMessage($chat_id, "👇", ['keyboard' => [[['text' => 'انصراف']]], 'resize_keyboard' => true, 'one_time_keyboard' => true], $platform);
    }
}
?>