<?php
if (basename(__FILE__) == basename($_SERVER['SCRIPT_FILENAME'])) {
    die('No direct script access allowed');
}

function showCardList(array $params, int $chat_id, ?int $message_id, int $user_id, string $platform, array $user): void {
    $cards = getUserCards($user_id);
    $text = "💳 *کارت‌های بانکی شما:*\n\n";
    $buttons = [];
    $can_edit = ($message_id !== null);

    if (empty($cards)) {
        $text .= "شما هنوز هیچ کارتی ثبت نکرده‌اید.";
    } else {
        foreach ($cards as $card) {
            $card_id = $card['id'] ?? 0;
            $masked_num = $card['card_number_masked'] ?? '****';
            if ($card_id > 0) {
                $text .= "- کارت `" . $masked_num . "`\n";
                $buttons[] = [['text' => "🗑 حذف کارت " . substr($masked_num, -4), 'callback_data' => buildCallbackData('deleteCardPrompt', ['card_id' => $card_id])]];
            }
        }
    }

    $buttons[] = [['text' => '➕ افزودن کارت جدید', 'callback_data' => buildCallbackData('addCard')]];
    $buttons[] = [['text' => '🔙 بازگشت به منو اصلی', 'callback_data' => buildCallbackData('mainMenu')]];
    $reply_markup_inline_only = ['inline_keyboard' => $buttons];

     if ($can_edit) {
         
         editMessage($chat_id, $message_id, $text, $reply_markup_inline_only);
     } else {
         
         sendMessage($chat_id, "مدیریت کارت‌ها:", getCustomerMainMenuKeyboard($user), $platform);
         
         sendMessage($chat_id, $text, $reply_markup_inline_only, $platform);
     }
}
?>