<?php
if (basename(__FILE__) == basename($_SERVER['SCRIPT_FILENAME'])) {
    die('No direct script access allowed');
}

function showCart(int $chat_id, int $user_id, ?int $message_id, string $platform, array $user): void {
    $cart_items = getCartContents($user_id);
    $buttons = [];
    $text = '';
    $can_edit = ($message_id !== null);
    $is_photo_message = false;

    if ($can_edit && isset($GLOBALS['update']['callback_query']['message']['photo'])) {
        $is_photo_message = true;
    }

    if (empty($cart_items)) {
        $text = "🛒 سبد خرید شما خالی است.";
        $buttons[] = [['text' => '🛍 مشاهده فروشگاه', 'callback_data' => buildCallbackData('viewCat', ['id' => null, 'offset' => 0])]];
    } else {
        $text = "🛒 *سبد خرید شما:*\n\n";
        $subtotal = '0.00';
        foreach ($cart_items as $item) {
            $quantity_str = (string)($item['quantity'] ?? '0');
            $price_str = (string)($item['pricing']['price'] ?? '0.00');
            $unit_str = $item['unit'] ?? '';
            $cart_item_id = $item['cart_item_id'] ?? 0;
            $item_name = htmlspecialchars($item['name'] ?? 'نامشخص');
            $formatted_price = number_format($item['pricing']['price'] ?? 0);

            $item_subtotal = bcmul($quantity_str, $price_str, BC_SCALE);
            $subtotal = bcadd($subtotal, $item_subtotal, BC_SCALE);
            $formatted_item_subtotal = number_format($item_subtotal);

            $text .= "🔹 *{$item_name}*\n   `{$quantity_str}` {$unit_str} × {$formatted_price} = `{$formatted_item_subtotal}` تومان\n";
            if ($cart_item_id > 0) {
                $item_buttons = [
                     ['text' => "➖", 'callback_data' => buildCallbackData('updateCartQty', ['item_id' => $cart_item_id, 'change' => '-1'])],
                     ['text' => "{$quantity_str}", 'callback_data' => 'noop'],
                     ['text' => "➕", 'callback_data' => buildCallbackData('updateCartQty', ['item_id' => $cart_item_id, 'change' => '+1'])],
                     ['text' => "🗑 حذف", 'callback_data' => buildCallbackData('removeCartItem', ['item_id' => $cart_item_id])]
                ];
                $buttons[] = $item_buttons;
            }
        }
          $text .= "\n-------------------------------------\n";
        $text .= "*جمع کل:* `" . number_format($subtotal) . "` تومان";

        $buttons[] = [['text' => '💳 تکمیل خرید و پرداخت', 'callback_data' => buildCallbackData('checkoutStart')]];
      
        $buttons[] = [['text' => '❌ خالی کردن سبد خرید', 'callback_data' => buildCallbackData('clearCartConfirm')]];
        $buttons[] = [['text' => '🛍 ادامه خرید', 'callback_data' => buildCallbackData('viewCat', ['id' => null, 'offset' => 0])]];
    }
    $buttons[] = [['text' => '🔙 بازگشت به منو اصلی', 'callback_data' => buildCallbackData('mainMenu')]];

    $reply_markup_inline_only = ['inline_keyboard' => $buttons];

     if ($can_edit) {
         
         if ($is_photo_message) {
             
             apiRequest('deleteMessage', ['chat_id' => $chat_id, 'message_id' => $message_id], $platform);
             
             sendMessage($chat_id, "سبد خرید:", getCustomerMainMenuKeyboard($user), $platform);
             
             sendMessage($chat_id, $text, $reply_markup_inline_only, $platform);
         } else {
             
             $current_text = $GLOBALS['update']['callback_query']['message']['text'] ?? null;
             $current_markup = isset($GLOBALS['update']['callback_query']['message']['reply_markup']) ? json_encode($GLOBALS['update']['callback_query']['message']['reply_markup']) : null;
             $new_markup = json_encode($reply_markup_inline_only);
             if ($current_text !== $text || $current_markup !== $new_markup) {
                 editMessage($chat_id, $message_id, $text, $reply_markup_inline_only);
             } else {
                 
                 $callback_query_id = $GLOBALS['update']['callback_query']['id'] ?? null;
                 if ($callback_query_id) { apiRequest('answerCallbackQuery', ['callback_query_id' => $callback_query_id], $platform); }
             }
         }
     } else {
         
         sendMessage($chat_id, "سبد خرید:", getCustomerMainMenuKeyboard($user), $platform);
         
         sendMessage($chat_id, $text, $reply_markup_inline_only, $platform);
     }
}
?>