<?php

if (basename(__FILE__) == basename($_SERVER['SCRIPT_FILENAME'])) {
    die('No direct script access allowed');
}

function startCheckout(array $params, int $chat_id, ?int $message_id, int $user_id, string $platform, array $user): void {
    $callback_query_id = $GLOBALS['update']['callback_query']['id'] ?? null;
    $can_edit = ($message_id !== null);

    $cart_items = getCartContents($user_id); 

    if (empty($cart_items)) {
        if ($callback_query_id) apiRequest('answerCallbackQuery', ['callback_query_id' => $callback_query_id, 'text' => 'سبد خرید شما خالی است.', 'show_alert' => true], $platform);
        if ($can_edit) {
            showCart($chat_id, $user_id, $message_id, $platform, $user);
        }
        return;
    }

    if (isset($user['referred_by_user_id']) && $user['referred_by_user_id'] !== null) {
        
        $session_data = json_decode($user['session'], true) ?? [];
        
        $session_data['selected_card_id'] = null; 
        $session_data['state'] = 'awaiting_checkout_province';
        
        unset($session_data['checkout']['province'], $session_data['checkout']['city']);
        unset($session_data['checkout']['address_text'], $session_data['checkout']['postal_code']);
        unset($session_data['checkout']['note']);
        
        updateUserField($user_id, 'session', json_encode($session_data));

        
        showProvinceSelector([], $chat_id, $message_id, $user_id, $platform, $session_data, $user);
        return;
    }
    
    $user_cards = getUserCards($user_id);
    if (empty($user_cards)) {
         $text = "💳 برای ادامه خرید، ابتدا باید حداقل یک کارت بانکی به نام خودتان ثبت کنید.";
         $buttons = [
             [['text' => '➕ افزودن کارت جدید', 'callback_data' => buildCallbackData('addCard')]],
             [['text' => '🛒 بازگشت به سبد خرید', 'callback_data' => buildCallbackData('viewCart')]]
         ];
         $reply_markup = ['inline_keyboard' => $buttons];
         if ($can_edit) {
             editMessage($chat_id, $message_id, $text, $reply_markup);
         } else {
             sendMessage($chat_id, $text, $reply_markup, $platform);
         }
         return;
    }

    
    $text = "💳 لطفا کارت بانکی مورد نظر برای پرداخت را انتخاب کنید:";
    $buttons = [];
    foreach ($user_cards as $card) {
        $card_id = $card['id'] ?? 0;
        $masked_num = $card['card_number_masked'] ?? '****';
        if ($card_id > 0) {
             $buttons[] = [['text' => $masked_num, 'callback_data' => buildCallbackData('selectCardForCheckout', ['card_id' => $card_id])]];
        }
    }
    $buttons[] = [['text' => '➕ افزودن کارت جدید', 'callback_data' => buildCallbackData('addCard')]];
    $buttons[] = [['text' => '🛒 بازگشت به سبد خرید', 'callback_data' => buildCallbackData('viewCart')]];
    $reply_markup = ['inline_keyboard' => $buttons];

     if ($can_edit) {
         editMessage($chat_id, $message_id, $text, $reply_markup);
     } else {
         sendMessage($chat_id, $text, $reply_markup, $platform);
     }

}

?>