<?php

// Prevent direct script access
if (basename(__FILE__) == basename($_SERVER['SCRIPT_FILENAME'])) {
    die('No direct script access allowed'); //
}

/**
 * Displays the main menu for the customer.
 * Logic from a.txt customer_handler.php, cases '/start', 'بازگشت به منو اصلی 🔙'
 */
function showCustomerMainMenu(int $chat_id, int $user_id, string $platform, array $user, ?int $message_id = null): void {

    // Ensure state is idle when showing main menu
    updateUserField($user_id, 'session', json_encode(['state' => 'idle'])); //

    // Delete previous message if it was an inline keyboard message
    if ($message_id) {
        @apiRequest('deleteMessage', ['chat_id' => $chat_id, 'message_id' => $message_id], $platform); //
    }

    $keyboard_markup = getCustomerMainMenuKeyboard($user); // Assumes KeyboardBuilders is loaded
    sendMessage($chat_id, "به فروشگاه ما خوش آمدید! چه کاری می‌توانم برایتان انجام دهم؟", $keyboard_markup, $platform); //
}
?>