<?php

// Prevent direct script access
if (basename(__FILE__) == basename($_SERVER['SCRIPT_FILENAME'])) {
    die('No direct script access allowed');
}

/**
 * Handles messages/input when the user is in the 'identity_rejected' status.
 * Primarily informs the user about the rejection.
 */
function handleRejectionMessage(int $chat_id, string $rejection_reason, string $platform): void {
    $msg = "❌ متاسفانه احراز هویت شما قبلا رد شده است."; 
    if (!empty($rejection_reason)) {
        $msg .= "\n\n*دلیل:* " . htmlspecialchars($rejection_reason); // Sanitize reason
    }
    $msg .= "\n\nلطفا با پشتیبانی تماس بگیرید یا با ارسال /start مجددا تلاش کنید (اطلاعات قبلی شما پاک خواهد شد)."; 
    
    sendMessage($chat_id, $msg, null, $platform); 
    // Note: The actual user reset happens when they send /start again (handled in VerificationHandler)
}

?>
