<?php

if (basename(__FILE__) == basename($_SERVER['SCRIPT_FILENAME'])) {
    die('No direct script access allowed');
}

function encryptCardNumber(string $cardNumber): ?string {
    if (!defined('CARD_ENCRYPTION_KEY') || !defined('CARD_ENCRYPTION_IV')) {
        if (defined('ERROR_LOG_PATH')) { file_put_contents(ERROR_LOG_PATH, date('Y-m-d H:i:s') . " - SECURITY ERROR: Card Encryption key or IV not defined.\n", FILE_APPEND); }
        return null;
    }
    $key = CARD_ENCRYPTION_KEY; 
    $iv = CARD_ENCRYPTION_IV; 
    $cipher = "aes-256-cbc"; 

    if (mb_strlen($key, '8bit') !== 32 || mb_strlen($iv, '8bit') !== 16) { 
        if (defined('ERROR_LOG_PATH')) { file_put_contents(ERROR_LOG_PATH, date('Y-m-d H:i:s') . " - SECURITY ERROR: Invalid Card encryption key or IV length (Key: " . mb_strlen($key, '8bit') . " bytes, IV: " . mb_strlen($iv, '8bit') . " bytes).\n", FILE_APPEND); }
        return null;
    }

    if (!in_array($cipher, openssl_get_cipher_methods())) {
        if (defined('ERROR_LOG_PATH')) { file_put_contents(ERROR_LOG_PATH, date('Y-m-d H:i:s') . " - Encryption Error: Cipher '{$cipher}' is not available.\n", FILE_APPEND); }
        return null;
    }

    $ciphertext = openssl_encrypt($cardNumber, $cipher, $key, OPENSSL_RAW_DATA, $iv); 
    if ($ciphertext === false) {
        $error = openssl_error_string(); 
        if (defined('ERROR_LOG_PATH')) { file_put_contents(ERROR_LOG_PATH, date('Y-m-d H:i:s') . " - Card Encryption Failed: " . $error . "\n", FILE_APPEND); }
        return null;
    }
    return base64_encode($ciphertext); 
}

function decryptCardNumber(string $encryptedCardNumber): ?string {
    if (!defined('CARD_ENCRYPTION_KEY') || !defined('CARD_ENCRYPTION_IV')) {
        if (defined('ERROR_LOG_PATH')) { file_put_contents(ERROR_LOG_PATH, date('Y-m-d H:i:s') . " - SECURITY ERROR: Card Decryption key or IV not defined.\n", FILE_APPEND); }
        return null;
    }
    $key = CARD_ENCRYPTION_KEY; 
    $iv = CARD_ENCRYPTION_IV; 
    $cipher = "aes-256-cbc"; 

    if (mb_strlen($key, '8bit') !== 32 || mb_strlen($iv, '8bit') !== 16) { 
        if (defined('ERROR_LOG_PATH')) { file_put_contents(ERROR_LOG_PATH, date('Y-m-d H:i:s') . " - SECURITY ERROR: Invalid Card decryption key or IV length.\n", FILE_APPEND); }
        return null;
    }

    if (!in_array($cipher, openssl_get_cipher_methods())) {
        if (defined('ERROR_LOG_PATH')) { file_put_contents(ERROR_LOG_PATH, date('Y-m-d H:i:s') . " - Decryption Error: Cipher '{$cipher}' is not available.\n", FILE_APPEND); }
        return null;
    }

    $ciphertext = base64_decode($encryptedCardNumber, true);
    if ($ciphertext === false) {
        if (defined('ERROR_LOG_PATH')) { file_put_contents(ERROR_LOG_PATH, date('Y-m-d H:i:s') . " - Card Decryption Failed: Invalid base64 input.\n", FILE_APPEND); }
        return null;
    }

    $original_plaintext = openssl_decrypt($ciphertext, $cipher, $key, OPENSSL_RAW_DATA, $iv); 
    if ($original_plaintext === false) {
        $error = openssl_error_string(); 
        if (defined('ERROR_LOG_PATH')) { file_put_contents(ERROR_LOG_PATH, date('Y-m-d H:i:s') . " - Card Decryption Failed: " . $error . "\n", FILE_APPEND); }
        return null;
    }
    return $original_plaintext; 
}

function encryptFileData(string $fileData): ?string {
    if (!defined('FILE_ENCRYPTION_KEY') || !defined('FILE_ENCRYPTION_IV')) {
        if (defined('ERROR_LOG_PATH')) { file_put_contents(ERROR_LOG_PATH, date('Y-m-d H:i:s') . " - SECURITY ERROR: File Encryption key or IV not defined.\n", FILE_APPEND); }
        return null;
    }
    $key = FILE_ENCRYPTION_KEY; 
    $iv = FILE_ENCRYPTION_IV; 
    $cipher = "aes-256-cbc"; 

    if (mb_strlen($key, '8bit') !== 32 || mb_strlen($iv, '8bit') !== 16) { 
        if (defined('ERROR_LOG_PATH')) { file_put_contents(ERROR_LOG_PATH, date('Y-m-d H:i:s') . " - SECURITY ERROR: Invalid File encryption key or IV length.\n", FILE_APPEND); }
        return null;
    }

    $ciphertext = openssl_encrypt($fileData, $cipher, $key, OPENSSL_RAW_DATA, $iv); 
    if ($ciphertext === false) {
        $error = openssl_error_string(); 
        if (defined('ERROR_LOG_PATH')) { file_put_contents(ERROR_LOG_PATH, date('Y-m-d H:i:s') . " - File Encryption Failed: " . $error . "\n", FILE_APPEND); }
        return null;
    }
    return $ciphertext; 
}

function decryptFileData(string $encryptedData): ?string {
    if (!defined('FILE_ENCRYPTION_KEY') || !defined('FILE_ENCRYPTION_IV')) {
        if (defined('ERROR_LOG_PATH')) { file_put_contents(ERROR_LOG_PATH, date('Y-m-d H:i:s') . " - SECURITY ERROR: File Decryption key or IV not defined.\n", FILE_APPEND); }
        return null;
    }
    $key = FILE_ENCRYPTION_KEY; 
    $iv = FILE_ENCRYPTION_IV; 
    $cipher = "aes-256-cbc"; 

    if (mb_strlen($key, '8bit') !== 32 || mb_strlen($iv, '8bit') !== 16) { 
        if (defined('ERROR_LOG_PATH')) { file_put_contents(ERROR_LOG_PATH, date('Y-m-d H:i:s') . " - SECURITY ERROR: Invalid File decryption key or IV length.\n", FILE_APPEND); }
        return null;
    }

    $original_plaintext = openssl_decrypt($encryptedData, $cipher, $key, OPENSSL_RAW_DATA, $iv); 
    if ($original_plaintext === false) {
        $error = openssl_error_string(); 
        if (defined('ERROR_LOG_PATH')) { file_put_contents(ERROR_LOG_PATH, date('Y-m-d H:i:s') . " - File Decryption Failed: " . $error . "\n", FILE_APPEND); }
        return null;
    }
    return $original_plaintext; 
}

?>